/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool.helpers;

public class ThreadHelpers {
    private ThreadHelpers() {
    }

    public static Runnable assignExceptionHandler(final Runnable runnable, final UncaughtExceptionHandler uncaughtExceptionHandler) {
        if (runnable == null || uncaughtExceptionHandler == null) {
            throw new NullPointerException();
        }
        return new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable2) {
                    try {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable2);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }
}

