package orp.coc.examples.observer

import orp.coc._
import scala.collection.mutable.ListBuffer

trait Subject {

  @any(classOf[ListBuffer[Observer]]) var observers: Observer = _

  def notifyObservers {
    observers().update(this)
  }
}

trait Observer {
  def update(s: Subject): Unit
}

case class NamedObserver(val name: String) extends Observer {
  override def update(s: Subject) {
    println("update of " + name + " from " + s)
  }
}

case class NamedSubject(val name: String) extends Subject

object ObserverApp extends App {

  val subject1 = new NamedSubject("Subject1")
  val subject2 = new NamedSubject("Subject2")

  val observer1 = NamedObserver("observer1")
  val observer2 = NamedObserver("observer2")
  val observer3 = NamedObserver("observer3")

  subject1.observers_+=(observer1)
  subject1.observers_+=(observer2)
  subject2.observers_+=(observer2)
  subject2.observers_+=(observer3)

  subject1.notifyObservers
  subject2.notifyObservers

}
