package orp.coc.test.codegeneration

import orp.coc._
import scala.collection.mutable.ListBuffer

class Person(val name: String) {

  override def toString = "Person(\"" + name + "\")"

  @any(classOf[ListBuffer[Person]]) var children: Person = _
  @one var father: Person = _
  @option var spouse: Person = _

  def childrenNames: List[String] = children.name
  //  def childrenNamesWithoutType: List[Person] = children.name
  def childrenNamesNative = childrenContainer.asBare map (p => p.name)

}

object PersonApp extends App {
  val p = new Person("John")
  val lisa = new Person("Lisa")
  val dummy = new Person("Dummy")

  println("p.children.getClass() : " + p.children.getClass())
  println("classOf[List[Person]].isAssignableFrom(p.children.getClass()) : " + classOf[List[Person]].isAssignableFrom(p.children.getClass()))

  p.children_+=(lisa)
  p.children_+=(dummy)
  println("p.children : " + p.children.asBare)

  println("remove (1) : " + p.childrenContainer(1))
  p.children_-=(p.children()(1))
  println("p.children : " + p.children.asBare)

  val ben = new Person("Ben")
  p.children_+=(ben)
  println("add (Ben) : " + p.children()(1))
  println("p.children = " + p.children.asBare)

  println("childrenNamesNative : " + p.childrenNamesNative)
  println("p.children.name : " + p.children.name)
  println("childrenNames : " + p.childrenNames)

  println("Select 1st Child")
  val child1 = p.children.apply(1)

  println("child 1 : " + child1)
  println("child 1's children : " + child1.children().asBare)

  println("p.children.children : " + p.children.children.asBare)
  println("p.children.children.names : " + p.children.children.name)

  println("adding to lisa")
  lisa.children_+=(new Person("LisaChild1"))
  lisa.children_+=(new Person("LisaChild2"))
  println("p.children.children : " + p.children.children.asBare)
  println("p.children.children.names : " + p.children.children.name)
  println("adding to dummy")
  ben.children_+=(new Person("BenChild1"))
  println("p.children.children : " + p.children.children.asBare)
  println("p.children.children.names : " + p.children.children.name)
  println("p.childrenContainer.map(x => x.childrenContainer) : " + p.childrenContainer.map(x => x.childrenContainer))
  println("dummy.children : " + dummy.children().asBare)

  println("get first child of p - should be Ben")
  println("p.children()(1) " + p.children()(1))
  val pChild1 = p.children()(1)

}